#ifndef __C4D_MEMORY_H
#define __C4D_MEMORY_H

#include "c4d_plugin.h"

void _GeFree(void **Daten);

#ifdef _DEBUG
	#define GeAlloc(x)     (C4DOS.Ge->Alloc((x),__LINE__,__FILE__))
#else
	#define GeAlloc(x)     (C4DOS.Ge->Alloc((x),0,NULL))
#endif

#define GeFree(x) _GeFree((void **)(&(x)))

void ClearMem(void *d, LONG size, LONG value=0);
void CopyMem(void *s, void *d, LONG size);

#ifdef __MAC
	#include <size_t.h>
	#if defined(__cplusplus) && defined(_MSL_USING_NAMESPACE)
		using namespace std;
	#endif
#endif

void* operator new(size_t s);
void* operator new(size_t s,int line,const CHAR *file);
void* operator new[](size_t s);
void* operator new[](size_t s,int line,const CHAR *file);
void operator delete(void *p);
void operator delete[](void *p);
void operator delete(void *p,int line,const CHAR *file);
void operator delete[](void *p,int line,const CHAR *file);

#define gNew new(__LINE__,__FILE__)
#define bNew new(__LINE__,__FILE__)

#define gDelete(v) {if(v) delete v; v=0;}
#define bDelete(v) {if(v) delete [] v; v=0;}

#include "ge_autoptr.h"

#define MEMORYPOOL_DEFAULT_BLOCKSIZE 0x80000

class MemoryPool
{
	private:
		MemoryPool(void);
	public:
		void *MemAlloc (LONG size, Bool clear=TRUE);
		void MemFree   (void *mem, LONG size);
		void *MemAllocS(LONG size, Bool clear=TRUE);
		void MemFreeS	 (void *mem);

		static MemoryPool *Alloc(void);
		static MemoryPool *Alloc(LONG block_size);
		static void Free(MemoryPool *&pool);
};

#endif